package jadean.dean.java.utilities;

import jadean.dean.java.constants.JavaProjectConstants;

public class DebugUtilities {
	public static void print(Object[] a) {
		for (Object o: a) {
			System.out.print(o + ", ");
		}
		System.out.println();
	}
	
	public static String translateResourceType(int resourceType) {
		switch (resourceType) {
		case JavaProjectConstants.RESOURCE_TYPE_CLASSPATH_PACKAGE:
			return "RESOURCE_TYPE_CLASSPATH_PACKAGE";
		case JavaProjectConstants.RESOURCE_TYPE_CLASSPATH_PACKAGE_CLASS:
			return "RESOURCE_TYPE_CLASSPATH_PACKAGE_CLASS";
		case JavaProjectConstants.RESOURCE_TYPE_PROJECT_CLASS:
			return "RESOURCE_TYPE_PROJECT_CLASS";
		case JavaProjectConstants.RESOURCE_TYPE_PROJECT_CLASS_INNER:
			return "RESOURCE_TYPE_PROJECT_CLASS_INNER";
		case JavaProjectConstants.RESOURCE_TYPE_PROJECT_PACKAGE:
			return "RESOURCE_TYPE_PROJECT_PACKAGE";
		case JavaProjectConstants.RESOURCE_TYPE_REFERENCED_PACKAGE:
			return "RESOURCE_TYPE_REFERENCED_PACKAGE";
		case JavaProjectConstants.RESOURCE_TYPE_REFERENCED_PACKAGE_CLASS:
			return "RESOURCE_TYPE_REFERENCED_PACKAGE_CLASS";
		default:
			return "RESOURCE_TYPE_UNKNOWN";
		}
	}
}
